/**
 * Andreas Solymosi: Covariance and contravariance in Java
 * Syntax test for Chapter 13. Variance of Lambdas
 * @author  Prof. Solymosi, Beuth University of Applied Sciences, Berlin
 * @version December 6, 2016
 */
package com.solymosi.javaworld.variances.test15;

import com.solymosi.javaworld.variances.SubType;
import com.solymosi.javaworld.variances.SuperType;

interface Type {}

@SuppressWarnings("serial")
class SuperException extends Exception {}
@SuppressWarnings("serial")
class SubException extends SuperException {}

@FunctionalInterface
interface SuperInterface {
	SuperType function() throws SuperException;
}
@FunctionalInterface
interface SubInterface extends SuperInterface {
	SubType function() throws SubException;
}

public class Test15 {
	static int counter = 0;
	static SuperType superFunction(SuperInterface superParameter) throws SuperException {
		System.out.println("superFunction " + ++counter);
		return superParameter.function(); // or do something more interesting
	}
	static SubType subFunction(SubInterface subParameter) throws SubException {
		System.out.println("subFunction" + ++counter);
		return subParameter.function(); // similarly
	}

	@SuppressWarnings("unused")
	public static void main(String[] args) throws SuperException {

		SuperType superVariable = superFunction(() -> new SuperType()); // 000 normal
		superVariable = subFunction(() -> new SubType()); // 011 simply compatible
		superVariable = superFunction(() -> new SubType()); // 001 covariant:
		// superVariable = subFunction(() -> new SuperType()); // 010 not applicable

		// SubType subVariable = (SubType) superFunction(() -> new SuperType()); // 100 ClassCastException
		// superVariable = subFunction(() -> new SuperType()); // 101 not applicable
		// subVariable = subFunction(() -> new SuperType()); // 110 cannot convert from SuperType to SubType		
		SubType subVariable = (SubType) superFunction(() -> new SubType()); // 111 normal			

		
		superVariable = superFunction( // 001 covariant
			new SubInterface(){
				public SubType function() throws SubException {
					return new SubType();
				}
			}
		);

				
				
						
	}
}
