/**
 * Andreas Solymosi: Covariance and contravariance in Java
 * Syntax test for Chapter 12. Variance of Methods
 * @author  Prof. Solymosi, Beuth University of Applied Sciences, Berlin
 * @version December 5, 2016
 */
package com.solymosi.javaworld.variances.test15;

interface Ober {
	static String data = "ober";
}
interface Unter extends Ober {
	static String data = "unter";	
}

// syntax test:
interface SuperType {
	<T>void procedure(T parameter);
	<T>T function(T parameter);
 }
interface SubType extends SuperType {
	@Override
	<T>void procedure(T parameter);
	@Override
	<T>T function(T parameter);
}

// presuppositions:
public class Test12a {
	public static void main(String[] args) {
		SuperType superReference = new SuperType() {
			@Override
			public <T>void procedure(T parameter) {
				System.out.println("Super " + parameter);
			}
			@Override
			public <T>T function(T parameter) { return null; }
		};

		SubType subReference = new SubType() {
			@Override
			public <T>void procedure(T parameter) {
				System.out.println("Sub" + parameter);				
			}
			@Override
			public <T>T function(T parameter) { return null; }
		};
		
		Ober superParameter = new Ober() {};
		Unter subParameter = new Unter() {};
		superReference.procedure(superParameter); // Super Ober -> normal
		subReference.procedure(superParameter); // Sub Ober -> polymorph		
		superReference.procedure(subParameter); // Super Unter -> compatibel
		subReference.procedure(subParameter); // Sub Unter -> compatibel+polymorph	
	}	
}