/**
 * Andreas Solymosi: Covariance and contravariance in Java
 * Syntax test for Chapter 13. Variance of Lambdas
 * @author  Prof. Solymosi, Beuth University of Applied Sciences, Berlin
 * @version December 6, 2016
 */
package com.solymosi.javaworld.variances.test13;

import com.solymosi.javaworld.variances.SubType;
import com.solymosi.javaworld.variances.SuperType;

//1. Generic functional interface
@FunctionalInterface
interface FunctInterface1<T> {
	void method(T parameter);
}
//2. Generic method in the functional interface -> error in lambda
@FunctionalInterface
interface FunctInterface2 {
	<T> void method(T parameter);
}

public class Test14 {
	// 1.
	static void procedure1(FunctInterface1<SuperType> functInterface) {
		functInterface.method(new SubType()); // 1. upward compatibility of method's parameter
	}
	// 2. 
	static void procedure2(FunctInterface2 functInterface) {
		functInterface.method(new SuperType());
	}
	// 3. wildcard parameter -> no suitable parameter for method() 
	static void procedure3(FunctInterface1<?> functInterface) {
		// functInterface.method(new Object()); // not applicable
	}
	// 4. parameter with upper bound-> no suitable parameter for method() 
	static void procedure4(FunctInterface1<? extends SuperType> functInterface) {
		// functInterface.method(new SuperType()); // not applicable
	}
	// 5. parameter with lower bound -> method() can be called only with the bound (no use of it) 
	static void procedure5(FunctInterface1<? super SubType> functInterface) {
		// functInterface.method(new SuperType()); // not applicable
		functInterface.method(new SubType());
	}
	
	public static void main(String[] args) {
		System.out.println("Begin");
		// 1. must be instantiated with the same type
		procedure1((SuperType superObject) -> { System.out.println(superObject); });
		// procedure1((SubType subObject) -> { System.out.println(subObject); });
		
		// 2. error: Illegal lambda expression: Method method of type FunctInterface2 is generic
		// procedure2((SuperType superObject) -> { System.out.println(superObject); } );
		
		// 5. lower bound
		procedure5((SuperType superObject) -> { System.out.println(superObject); } );
		procedure5((SubType subObject) -> { System.out.println(subObject); } );
		
		System.out.println("End");		
	}
}