/**
 * Andreas Solymosi: Covariance and contravariance in Java
 * Syntax test for Chapter 12. Variance of Methods
 * @author  Prof. Solymosi, Beuth University of Applied Sciences, Berlin
 * @version December 5, 2016
 */
package com.solymosi.javaworld.variances.test12;

// syntax test:
interface SuperType {
	void procedure(SuperType parameter);
	SuperType function();
 }
interface SubType extends SuperType {
	// @Override void procedure(SubType parameter);
	// void procedure(SubType parameter); // overloaded: different signature
	@Override
	SubType function(); // overridden: same signature, different result type
}

// presuppositions:
public class Test12 {
	@SuppressWarnings("unused")
	public static void main(String[] args) {
		SuperType superReference = new SuperType() {
			public void procedure(SuperType parameter) {}
			public SuperType function() { return null; }};
		SubType subReference = new SubType() {
			public void procedure(SuperType parameter) {}
			public SubType function() {return null; }} ;
			
		@SuppressWarnings("serial")
		class SuperException extends Exception {}
		@SuppressWarnings("serial")
		class SubException extends SuperException {}

		// syntax test:
		SuperType superParameter = null ;
		SubType subParameter = null ;
		superReference.procedure(subParameter); // call is covariant concerning signature
		subReference.procedure(superParameter); // polymorph
		
		SuperType superResult = subReference.function(); // upward compatible
		// SubType subResult = superReference.function();
			// error: no downward compatibility

		class SuperClass {
			void method() throws SuperException { }
		}
		class SubClass extends SuperClass {
			@Override
			final void method() throws SubException { }
		}
	}	
}