/**
 * Andreas Solymosi: Covariance and contravariance in Java
 * Syntax test for Chapter 11. Multiple Type Parameters
 * @author  Prof. Solymosi, Beuth University of Applied Sciences, Berlin
 * @version December 5, 2016
 */
package com.solymosi.javaworld.variances.test11;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

import com.solymosi.javaworld.variances.SubType;
import com.solymosi.javaworld.variances.SuperType;

// presuppositions:
class HashMap<K, V> implements Map<K, V> 
{
	public HashMap(Map<? extends K,? extends V> m)	
	{}
	public void clear() {}
	public boolean containsKey(Object key) { return false; }
	public boolean containsValue(Object value) { return false; }
	public Set<java.util.Map.Entry<K, V>> entrySet() { return null; }
	public V get(Object key) { return null; }
	public boolean isEmpty() { return false; }
	public Set<K> keySet() { return null; }
	public V put(K key, V value) { return null; }
	public void putAll(Map<? extends K, ? extends V> m) {}
	public V remove(Object key) { return null; }
	public int size() { return 0; }
	public Collection<V> values() { return null; }
}

interface Person {}
interface Id {}
interface Customer extends Person {}
interface CustomerNumber extends Id {}
	
public class Test11 {
	@SuppressWarnings("unused")
	public static void main(String[] args) {
		Map<Id, Person> contacts;

// syntax test:
		class G<T1, T2> {}
		G<? extends SuperType, ? super SubType> reference;
		reference = new G<SuperType, SubType>(); // without variance
		reference = new G<SubType, SuperType>(); // co- and contravariance
		
		Map<CustomerNumber, Customer> customers;
		customers = null; //--
		// 
		contacts = new HashMap<Id, Person>(customers); // covariant		
	}	
}