/**
 * Andreas Solymosi: Covariance and contravariance in Java
 * Syntax test for Chapter 10. Creation of Objects
 * @author  Prof. Solymosi, Beuth University of Applied Sciences, Berlin
 * @version December 5, 2016
 */
package com.solymosi.javaworld.variances.test10;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

import com.solymosi.javaworld.variances.Generic;

public class Test10 {
	@SuppressWarnings("unchecked")
	public static void main(String[] args) {

// syntax test:
		Generic<Object>[] genericArray;
		// genericArray = new Generic<Object>[20]; // error
		Generic<?>[] wildcardArray = new Generic<?>[20]; // OK
		genericArray = (Generic<Object>[])wildcardArray; // unchecked conversion
		genericArray[0] = new Generic<Object>();
		// genericArray[0] = new Generic<String>(); // type error
		wildcardArray[0] = new Generic<String>(); // OK	

		@SuppressWarnings("unused")
		class MyArrayList<E> implements List<E> {
			private E[] content;
			MyArrayList(int size) {
				// content = new E[size]; // error
				content = (E[])new Object[size]; // workaround
			}
			MyArrayList(Class<E> myClass, int size) { //--
				content = (E[])java.lang.reflect.Array.newInstance(myClass, size);
			}
			// 
		// presuppositions:
			public boolean add(E arg0) { return false; }
			public void add(int arg0, E arg1) {}
			public boolean addAll(Collection<? extends E> arg0) { return false; }
			public boolean addAll(int arg0, Collection<? extends E> arg1) { return false; }
			public void clear() {}
			public boolean contains(Object arg0) { return false; }
			public boolean containsAll(Collection<?> arg0) { return false; }
			public E get(int arg0) { return null; }
			public int indexOf(Object arg0) { return 0; }
			public boolean isEmpty() { return false; }
			public Iterator<E> iterator() { return null; }
			public int lastIndexOf(Object arg0) { return 0; }
			public ListIterator<E> listIterator() { return null; }
			public ListIterator<E> listIterator(int arg0) { return null; }
			public boolean remove(Object arg0) { return false; }
			public E remove(int arg0) { return null; }
			public boolean removeAll(Collection<?> arg0) { return false; }
			public boolean retainAll(Collection<?> arg0) { return false; }
			public E set(int arg0, E arg1) { return null; }
			public int size() { return 0; }
			public List<E> subList(int arg0, int arg1) { return null; }
			public Object[] toArray() { return null; }
			public <T> T[] toArray(T[] arg0) { return null; }
		}
	}
}