/**
 * Andreas Solymosi: Covariance and contravariance in Java
 * Syntax test for Chapter 9. Contravariant Type Parameter as Method Parameter
 * @author  Prof. Solymosi, Beuth University of Applied Sciences, Berlin
 * @version December 5, 2016
 */
package com.solymosi.javaworld.variances.test09;

import com.solymosi.javaworld.variances.test06.Generic;

// presuppositions:
	class SuperSuperType {}
	class SuperType extends SuperSuperType {}
	class SubType extends SuperType {}
	class SubSubType extends SubType {}

	class SuperClass {}
	class SubClass extends SuperClass {}		
	
public class Test09 {
	@SuppressWarnings("unused")
	public static void main(String[] args) {

		Generic<SuperSuperType> contravariantReference = new Generic<SuperSuperType>(); // dummy
		
// syntax test:
		contravariantReference.write(new SubType()); // OK
		contravariantReference.write(new SubSubType()); // OK too
		// contravariantReference.write(new SuperType()); // type error
		((Generic<? super SuperType>)contravariantReference).write(
			new SuperType()); // OK
		
		Object o = contravariantReference.read();
		// SubType st = contravariantReference.read(); // type error

		SuperSuperType sst = ((Generic<SuperSuperType>)contravariantReference).read();
		sst = (SuperSuperType)contravariantReference.read(); // unsafe alternative		
	}	
}