/**
 * Andreas Solymosi: Covariance and contravariance in Java
 * Read-write test for accessing variables of a type parameter: variances (covariance and contravariance) is tested
 * Test program for the Table 9 in Chapter 9 
 * @author  Prof. Solymosi, Beuth University of Applied Sciences, Berlin
 * @version December 5, 2016
 */
package com.solymosi.javaworld.variances.test09;

import com.solymosi.javaworld.variances.SubType;
import com.solymosi.javaworld.variances.SubSubType;
import com.solymosi.javaworld.variances.SuperType;
import com.solymosi.javaworld.variances.SuperSuperType;
import com.solymosi.javaworld.variances.test06.Generic;

public class ReadWrite {
	@SuppressWarnings({ "unused", "unchecked"})
	public static void main(String[] args) {
		/* errors have been commented out and explained in line comment
		 * warning "Unchecked cast" and been suppressed and commented as "warning"
		 */

		Generic<?> wildcardReference;
		Generic<? extends SuperType> covariantReference;
		Generic<? super SubType> contravariantReference;
		Object object;
		SuperType superReference;
		SubType subReference;
		
	// compatibility test:
		
		wildcardReference = new Generic<Integer>() {};
		wildcardReference = new Generic<SuperType>() {};
		wildcardReference = new Generic<SubType>() {};
			// wildcard type is a supertype for all instantiations
		
		covariantReference = new Generic<SuperType>() {};
		covariantReference = new Generic<SubType>() {};
			// subtype instantiation is compatible to supertype instantiation: ? extends -> explicit covariance 
		covariantReference = new Generic<SubSubType>() {};
		// covariantReference = new Generic<SuperType>() {}; // cannot convert: only subtypes work
		// covariantReference = new Generic<Object>() {}; // cannot convert: only subtypes work
			// covariance does not work "from above"
		
		contravariantReference = new Generic<SubType>() {};
		contravariantReference = new Generic<SubType>() {};
		contravariantReference = new Generic<SuperType>() {};
		contravariantReference = new Generic<SuperSuperType>() {};
		contravariantReference = new Generic<Object>() {}; // contravariant
			// contravariance works "from above", not from below:
		// contravariantReference = new Generic<SubSubType>() {}; // cannot convert: SubSubType is not a supertype of SubType

/* Every access is tested twice: through method and through direct access.
 * 	Both produces the same behavior but different error messages: "not applicable" resp. "cannot convert"
 */		
		
	// 1.write test:
	// 1.1. write Object -> not applicable / cannot convert (because Object is not compatible to any other type)
		// wildcardReference.write(new Object()); wildcardReference.data = new Object(); // Object is not compatible to ?
		// covariantReference.write(new Object()); covariantReference.data = new Object(); // Object is not compatible to ? extends SuperType
		// contravariantReference.write(new Object()); contravariantReference.data = new Object(); // Object is not compatible to ? super SubType 
		
	// 1.2. write Object with cast:
		((Generic<Object>)wildcardReference).write(new Object()); ((Generic<Object>)wildcardReference).data = new Object(); // warning
		// ((Generic<Object>)covariantReference).write(new Object()); ((Generic<Object>)covariantReference).data = new Object(); // Cannot cast (generics are not variant)
		((Generic<Object>)contravariantReference).write(new Object()); ((Generic<Object>)contravariantReference).data = new Object(); // warning
		
	// 1.3. write SuperType: -> not applicable / cannot convert (because SuperType is not compatible to ?)
		// wildcardReference.write(new SuperType()); wildcardReference.data = new SuperType();
		// covariantReference.write(new SuperType()); covariantReference.data = new SuperType();
		// contravariantReference.write(new SuperType()); contravariantReference.data = new SuperType();

	// 1.4. write SuperType with cast:
		((Generic<SuperType>)wildcardReference).write(new SuperType()); ((Generic<SuperType>)wildcardReference).data = new SuperType(); // warning
		((Generic<SuperType>)covariantReference).write(new SuperType()); ((Generic<SuperType>)covariantReference).data = new SuperType(); // warning
		((Generic<SuperType>)contravariantReference).write(new SuperType()); ((Generic<SuperType>)contravariantReference).data = new SuperType(); // warning		

	// 1.5. write SubType:
		// wildcardReference.write(new SubType()); wildcardReference.data = new SubType(); // not applicable / cannot convert 
		// covariantReference.write(new SubType()); covariantReference.data = new SubType(); // not applicable
		contravariantReference.write(new SubType()); contravariantReference.data = new SubType();
			// typical case for contravariance
					
	// 1.6. write SubType with cast:
	// 1.6.1 write SubType with proper cast:
		((Generic<SubType>)wildcardReference).write(new SubType()); ((Generic<SubType>)wildcardReference).data = new SubType(); // warning
		((Generic<SubType>)covariantReference).write(new SubType()); ((Generic<SubType>)covariantReference).data = new SubType(); // warning
		((Generic<SubType>)contravariantReference).write(new SubType()); ((Generic<SubType>)contravariantReference).data = new SubType(); // warning
		
	// 1.6.2 write SubType with different cast:
		((Generic<SuperType>)covariantReference).write(new SubType()); ((Generic<SuperType>)covariantReference).data = new SubType(); // warning 			// SupType is compatible to SuperType

	// 1.6.3. write SubType with cast to Object:
		// ((Generic<Object>)covariantReference).write(new SubType()); ((Generic<Object>)covariantReference).data = new SubType(); // Cannot cast
			// wildcard instantiation is not compatible to other (here: Object) instantiation
		((Generic<Object>)contravariantReference).write(new SubType()); ((Generic<Object>)contravariantReference).data = new SubType(); // Unchecked cast
			// contravariance

	// 2. read test:		
	// 2.1. read into Object:		
		object = wildcardReference.read(); object = wildcardReference.data;
		object = covariantReference.read(); object = covariantReference.data;
		object = contravariantReference.read(); object = contravariantReference.data;
			// ? is compatible to Object
		
	// 2.2. read into SuperType:
		// SuperType superReference = wildcardReference.read(); SuperType superReference = wildcardReference.data; // cannot convert
			// ? is not compatible to ? to SuperType 
		superReference = covariantReference.read(); superReference = covariantReference.data;
			// typical case for covariance 
		// superReference = contravariantReference.read(); superReference = contravariantReference.data; // cannot convert
			// ? super SubType is not compatible to SuperType
		
	// 2.3. read into SuperType with casting the data -> OK
		superReference = (SuperType)wildcardReference.read(); superReference = (SuperType)wildcardReference.data;
		superReference = (SuperType)covariantReference.read(); superReference = (SuperType)covariantReference.data;
		superReference = (SuperType)contravariantReference.read(); superReference = (SuperType)contravariantReference.data;

	// 2.4. read into SuperType with casting the reference -> cannot cast ? to SuperType
		// superReference = ((SuperType)wildcardReference).read(); superReference = (SuperType)wildcardReference.data;
		// superReference = ((SuperType)covariantReference).read(); superReference = (SuperType)covariantReference.data;
		// superReference = ((SuperType)contravariantReference).read(); superReference = (SuperType)contravariantReference.data;
		
	// 2.5. read into SubType -> cannot convert: ? is compatible only to Object		
		// SubType subReference = wildcardReference.read(); subReference = wildcardReference.data; 
		// SubType subReference = covariantReference.read(); subReference = covariantReference.data;
		// SubType subReference = contravariantReference.read(); subReference = contravariantReference.data;
		
	// 2.6. read into SubType with casting the result -> OK
		subReference = (SubType)wildcardReference.read(); subReference = (SubType) wildcardReference.data;
		subReference = (SubType)covariantReference.read(); subReference = (SubType) covariantReference.data;
		subReference = (SubType)contravariantReference.read(); subReference = (SubType) contravariantReference.data;
		
	// 2.7. read into SubType with casting the reference -> OK with warning
	// 2.7.1 read into SubType with proper cast:
		subReference = ((Generic<SubType>)wildcardReference).read(); subReference = ((Generic<SubType>)wildcardReference).data; // warning
		subReference = ((Generic<SubType>)covariantReference).read(); subReference = ((Generic<SubType>)covariantReference).data; // warning
		subReference = ((Generic<SubType>)contravariantReference).read(); subReference = ((Generic<SubType>)contravariantReference).data; // warning

	// 2.7.2 read into SubType with different cast -> cannot convert SuperType to SubType or Object
		// subReference = ((Generic<SuperType>)wildcardReference).read(); subReference = ((Generic<SubType>)wildcardReference).data; 
		// subReference = ((Generic<Object>)wildcardReference).read(); subReference = ((Generic<SubType>)wildcardReference).data; 
		// subReference = ((Generic<SuperType>)covariantReference).read(); subReference = ((Generic<SubType>)covariantReference).data;
		// subReference = ((Generic<SuperType>)contravariantReference).read(); subReference = ((Generic<SubType>)contravariantReference).data;		
	}	
}