/**
 * Andreas Solymosi: Covariance and contravariance in Java
 * Syntax test for Chapter 8. API Examples for Contravariance
 * @author  Prof. Solymosi, Beuth University of Applied Sciences, Berlin
 * @version December 5, 2016
 */
package com.solymosi.javaworld.variances.test08;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import static java.util.Collections.sort;

interface Dummy {

// syntax test:
	<T> void sort(List<T> list, Comparator<? super T> c);
	<T extends Comparable<? super T>> void sort(List<T> list);
	<T> //--
	int compare(T o1, T o2);
}

class Customer implements Comparable<Customer> {
	@Override
	public int compareTo(Customer o) { return 0; }
}

class DateComparator implements Comparator<java.util.Date> { 
	public int compare(Date d1, Date d2) { return //  } // compares the two Date Objects
		0; // --
	}
}

class SqlDateComparator extends DateComparator {} // dummy
	
class SuperClass implements Comparable<SuperClass> {
	public int compareTo(SuperClass s) { // 
		return 0; // --
	}
}
class SubClass extends SuperClass {} // without overloading of compareTo()
		
// presuppositions:
class AType extends AnOtherType {}	
class AnOtherType {}
public class Test08 {	

// syntax test:

	public static <T extends Object & Comparable<? super T>> T max(
		Collection<? extends T> collection) { //  }
			{ return collection.iterator().next(); } // --
	}

	public static <T> T max(Collection<? extends T> collection,
		Comparator<? super T> comp)
			{ return collection.iterator().next(); } // --
	
	public static void main(String[] args) {
		List<Integer> integerList = new ArrayList<Integer>();
		List<Customer> customerList = new ArrayList<Customer>();
		
		
		sort(integerList); // Integer implements Comparable
		sort(customerList); // works only if Customer implements Comparable

		// Alternate syntax test:
		Dummy dummy = new Dummy () {
			@Override
			public <T> void sort(List<T> list, Comparator<? super T> c) {}
			@Override
			public <T extends Comparable<? super T>> void sort(List<T> list) {}
			@Override
			public <T> int compare(T o1, T o2) { return 0; }
		};
		dummy.sort(integerList); // Integer implements Comparable
		dummy.sort(customerList); // works only if Customer implements Comparable
		
		// Syntax test:
		List<java.util.Date> list = //  ; // List of Date objects
			new ArrayList<java.util.Date>(); // --
		sort(list, new DateComparator()); // sorts list
		
		List<java.sql.Date> sqlList = //  ;
			new ArrayList<java.sql.Date>(); // --
		sort(sqlList, new DateComparator()); 

		sort(sqlList, new SqlDateComparator());
		
		Collection<AType> collection = //  ;
			new ArrayList<AType>(); // dummy
		Comparator<AnOtherType> comparator = //  ;
			new Comparator<AnOtherType>() { public int compare(AnOtherType o1, AnOtherType o2) { return 0; } }; // dummy
		max(collection, comparator);		

		sort(list); // java.util.Date implements Comparable<java.util.Date>
		sort(sqlList); // java.sql.Date implements Comparable<java.sql.Date>	

		List<SuperClass> superList = // ;
			new ArrayList<SuperClass>(); // dummy
		sort(superList);
		List<SubClass> subList = // ;
			new ArrayList<SubClass>(); // dummy
		sort(subList);
	}	
}