/**
 * Andreas Solymosi: Covariance and contravariance in Java
 * Syntax test for Chapter 7. Contravariance for Parametrized Types
 * @author  Prof. Solymosi, Beuth University of Applied Sciences, Berlin
 * @version December 5, 2016
 */
package com.solymosi.javaworld.variances.test07;

import com.solymosi.javaworld.variances.SubType;
import com.solymosi.javaworld.variances.SuperType;

// presuppositions:
class Generic<T> {
	T data;
	void write(T data) { this.data = data; } // T is input parameter type
	T read() { return data; } } // T is output parameter type

public class Test07 {
	@SuppressWarnings("unused")
	public static void main(String[] args) {
		SuperType[] superArray = new SuperType[100];
		SubType[] subArray;

		Object object;
		String string;
		
// syntax test:		
		subArray = (SubType[])superArray; // explicit compatible (contravariant)
		
		Generic<? super SubType> contravariantReference;

		contravariantReference = new Generic<SubType>(); // normal
		contravariantReference = new Generic<SuperType>(); // contravariant
		contravariantReference = new Generic<Object>(); // also possible		
		
		Generic<? super Object> contravariantO = new Generic<Object>();
		contravariantO.data = new Object(); // now is OK: writing is possible
		object = contravariantO.data; // also reading 
		contravariantO.write(new Object()); // now is OK
		object = contravariantO.read(); // 		

		Generic<? super String> contravariantS = new Generic<String>();
		contravariantS.data = new String(); // OK
		// string = contravariantS.data; // Error: contrary to covariant case 
		contravariantS.write(new String()); // OK
		// string = contravariantS.read(); // error
	}	
}