/**
 * Andreas Solymosi: Covariance and contravariance in Java
 * Syntax test for Chapter 6. Covariant Type Parameter As Parameter Type
 * @author  Prof. Solymosi, Beuth University of Applied Sciences, Berlin
 * @version December 5, 2016
 */
package com.solymosi.javaworld.variances.test06;

import com.solymosi.javaworld.variances.SubType;
import com.solymosi.javaworld.variances.SuperType;

// presuppositions:
public class Test06 {
	@SuppressWarnings({ "unchecked", "unused" })
	public static void main(String[] args) {

		Generic<?> wildcardReference = new Generic<Integer>() {};
		Generic<? extends SuperType> covariantReference = new Generic<SuperType>() {};

// syntax test:	
		// wildcardReference.write(new Object()); // type error
		((Generic<Object>)wildcardReference).write(new Object()); // OK
			// however: warning Unchecked cast by the compiler

		Object object = wildcardReference.read();
		
		// covariantReference.write(new SuperType()); // type error
		// covariantReference.write(new SubType()); // type error
		((Generic<SuperType>)covariantReference).write(new SuperType()); // OK
		((Generic<SuperType>)covariantReference).write(new SubType()); // OK 
		((Generic<SubType>)covariantReference).write(new SubType()); //OK 
		object = covariantReference.read(); // OK
		SuperType superReference = covariantReference.read(); // OK
		// SubType subReference1 = covariantReference.read(); // type error
		SubType subReference2 = ((Generic<SubType>)covariantReference).read(); //OK
		SubType subReference3 = (SubType)covariantReference.read(); // unsafe
		
		// wildcardReference.data = new Object(); // writing access -> error
		object = wildcardReference.data; // reading access is OK
		// wildcardReference.write(new Object()); // writing access -> error
		object = wildcardReference.read(); // reading access is OK
		// String string = wildcardReference.data; // error: ? is compatible only to Object 
		Generic<? extends String> covariant = new Generic<String>();
		String string = covariant.data; // writing is possible with upper bound
	}
	
}