/**
 * Andreas Solymosi: Covariance and contravariance in Java
 * Syntax test for Chapter 5. Explicit Covariance for Parametrized Types
 * @author  Prof. Solymosi, Beuth University of Applied Sciences, Berlin
 * @version December 5, 2016
 */
package com.solymosi.javaworld.variances.test05;
import java.util.ArrayList;
import java.util.Collection;

import com.solymosi.javaworld.variances.Generic;
import com.solymosi.javaworld.variances.SubType;
import com.solymosi.javaworld.variances.SuperType;

public class Test05 {
// syntax test:	
		static void increment(Number[] array) { //  } // for every element + 1
		} // --
		static void increment(Collection<? extends Number> collection) { //  }
			// similarly
		} // --

	@SuppressWarnings("unused")
	public static void main(String[] args) {
		Generic<? extends SuperType> covariantReference;
		
		covariantReference = new Generic<SuperType>();
		covariantReference = new Generic<SubType>();
		// covariantReference = new Generic<Object>(); // error: only subtypes work

		Integer[] integerArray = {1, 2, 3};
		ArrayList<Integer> integerArrayList = new ArrayList<Integer>(); // dummy
		
		increment(integerArray); // Integer[] is compatible to Number[]
		increment(integerArrayList);
			// ArrayList<Integer> is compatible to Collection<? extends Number>
	}	
}
