/**
 * Andreas Solymosi: Covariance and contravariance in Java
 * Syntax test for Chapter 4. Unspecific Covariance for Parametrized Types
 * @author  Prof. Solymosi, Beuth University of Applied Sciences, Berlin
 * @version December 5, 2016
 */
package com.solymosi.javaworld.variances.test04;
import java.util.ArrayList;
import java.util.List;

import com.solymosi.javaworld.variances.SubType;
import com.solymosi.javaworld.variances.SuperType;
import com.solymosi.javaworld.variances.Generic;

//syntax test:
interface T1 { //--
	void method(Generic<SuperType> p);		
} //--
interface T2 { //--
	void method(Generic<SubType> p);
} //--

public class Test04 { //--
	static void swap(Object[] array, int i, int j) {
		//  // swaps the elements i and j
	}
	static <T> void swap_(T[] array, int i, int j) {
		// 
	}
	static void swap(List<?> list, int i, int j) {
		// 
	} // similarly
	
// presuppositions:
	@SuppressWarnings("unused")
	public static void main(String[] args) {

// syntax test:	
		Generic<SuperType> superGeneric;
		Generic<SubType> subGeneric;
		// subGeneric = (Generic<SubType>)superGeneric; // type error
		// superGeneric = (Generic<SuperType>)subGeneric; // type error

// presuppositions:		
		subGeneric = new Generic<SubType>();
		superGeneric = new Generic<SuperType>();
		boolean b =
				
// syntax test:	
		subGeneric.getClass() == superGeneric.getClass();
			
		Generic<?> wildcardReference;
		wildcardReference = new Generic<String>(); // implicitly compatible
		wildcardReference = new Generic<Integer>(); // implicitly compatible

		// new Generic<?>()

		Integer[] integerArray = {1, 2, 3};
		swap(integerArray, 0, 2); // Integer[] is compatible to Object[]
		
		List<Integer> list = // ;
			new ArrayList<Integer>(); // --
		swap(list, 0, 2); // List<Integer> is compatible to List<?>

		ArrayList<Integer> arrayList = //  ; // ArrayList<T> implements List<T>
				new ArrayList<Integer>(); // dummy				
		swap(list, 0, 2); // ArrayList<Integer> is compatible to List<?>
	}	
}