/**
 * Andreas Solymosi: Covariance and contravariance in Java
 * Syntax test for Chapter 3. Covariance and Contravariance of Arrays
 * @author  Prof. Solymosi, Beuth University of Applied Sciences, Berlin
 * @version December 5, 2016
 */

package com.solymosi.javaworld.variances.test03;

import com.solymosi.javaworld.variances.SubType;
import com.solymosi.javaworld.variances.SuperType;

// presuppositions:

	class Generic<T> {}
	
public class Test03 {
	@SuppressWarnings("unused")
	public static void main(String[] args) {

		int[] intArray;
		long[] longArray;
		short[] shortArray;
		
// syntax test:		
		// longArray = intArray; // type error
		// shortArray = (short[])intArray; // type error
		
		SuperType[] superArray;
		SubType[] subArray;

		subArray = new SubType[100]; // --
			
		superArray = subArray; // implicitly covariant
		subArray = (SubType[])superArray; // explicitly contravariant
		
		superArray[1] = new SuperType(); // throws ArrayStoreException
		
		Object[] objectArray; // array reference
		objectArray = new String[3]; // array object; compatible assignment
		objectArray[0] = new Integer(5); // throws ArrayStoreException
	}	
}