/**
 * Andreas Solymosi: Covariance and contravariance in Java
 * Syntax test for Chapter 2. Compatibility of Different Types
 * @author  Prof. Solymosi, Beuth University of Applied Sciences, Berlin
 * @version December 5, 2016
 */

package com.solymosi.javaworld.variances.test02;

import com.solymosi.javaworld.variances.SubType;
import com.solymosi.javaworld.variances.SuperType;

// presuppositions:
	interface T1 {}
	interface T2 {}

public class Test02 {
	@SuppressWarnings("unused")
	public static void main(String[] args) {
		
		T1 variableOfTypeT1 = new T1() {};
		T2 variableOfTypeT2;

		SuperType referenceOfSuperType = new SuperType();
		SubType referenceOfSubType = new SubType();	

// syntax test:		
		// variableOfTypeT2 = variableOfTypeT1; // implicit compatible - error
		variableOfTypeT2 = (T2)variableOfTypeT1; // explicit compatible
		
		int i = 5;
		long l = i; // implicit compatible
		short s = (short)i; // explicit compatible
	
		referenceOfSuperType = referenceOfSubType; // implicit compatible
		referenceOfSubType = (SubType)referenceOfSuperType; // explicit compatible
	}	
}