/**
 * Andreas Solymosi: Covariance and contravariance in Java
 * Syntax test for Chapter 1. Introduction
 * @author  Prof. Solymosi, Beuth University of Applied Sciences, Berlin
 * @version December 5, 2016
 */
package com.solymosi.javaworld.variances.test01;
public class Test01 {

/* Legende:
 * // Syntax test:
 * 	the following lines are from the text 
 * // Presuppositions:	
 * 	the following lines are necessary for the syntax check
 * //-- 
 * 	this additional line is necessary for the syntax check
 * //
 * line marked in text as error has been commented out
*/
	
	@SuppressWarnings("unused") //--
	public static void main(String[] args) { //--

	// Compatibility
		
		short s; int i;
		boolean b;

		s = 0; //--
		b = true; //--
		
		// Test:
		i = s;
		// i = b;
		
		Number number; Integer integer;		

		integer = 5; //--

		number = integer;
		integer = (Integer) number;
		
		// s = i;
		s = (short)i; 
		
		// integer = number;
		integer = (Integer) number;
		
	// Dependency

		abstract class Dummy { //--
			abstract void increment(Integer i);
		} //--		

	// Covariance
		
		Integer[] integerArray; Number[] numberArray;
		integerArray = new Integer[100]; //--		
		numberArray = new Number[100]; //--		
		numberArray = integerArray;
		// integerArray = numberArray;
		integerArray = (Integer[])numberArray;
	}

}
