/** @(#)LatchableListQ.java
 * Implementation of the latchable queue as linked list
 * @version February 22, 2017
 * @author Prof. Solymosi  2010-2017
 * @param E type of the elements in the queue */

package com.solymosi.javaworld.queue.step7;

import com.solymosi.javaworld.queue.step1.ListQ;

public class LatchableListQ<E> extends ListQ<E> implements ILatchableQ<E> {
	private Latch latch;
	public LatchableListQ() {
		latch = new Latch(); }

	@Override public void add(E o) {
		if (isLatched(latch))
			throw new IllegalStateException();
		else
			super.add(o); }

	public static void main(String[] args) {
		LatchableArrayQ2<Integer> caq1 = new LatchableArrayQ2<Integer>(10),
				caq2 = new LatchableArrayQ2<Integer>(10);
			System.out.println("add 1");
			caq1.add(1);
			caq1.latch();
			caq1.unlatch(); 
			System.out.println("add 2");
			caq1.add(2);
			caq1.latch();
			System.out.println("add 3");
			caq2.add(3);
			System.out.println("add 3");
			caq1.add(4); // throws IllegalStateException
			System.out.println("End"); } }