/** @(#)LatchableArrayQ2.java
 * Implementation of the latchable queue - second try
 * @version February 21, 2017
 * @author Prof. Solymosi  2010-2017
 * @param E type of the elements in the queue */

package com.solymosi.javaworld.queue.step7;

import com.solymosi.javaworld.queue.step1.ArrayQ;

public class LatchableArrayQ2<E> extends ArrayQ<E> implements ILatchableQ2<E> {
	public LatchableArrayQ2(final int size) {
		super(size); }
	@Override public void add(E o) {
		if (isLatched())
			throw new IllegalStateException();
		else
			super.add(o); }

	public static void main(String[] args) {
		ILatchableQ2<Integer> caq1 = new LatchableArrayQ2<Integer>(10),
			caq2 = new LatchableArrayQ2<Integer>(10);
		System.out.println("add 1");
		caq1.add(1);
		caq1.latch();
		caq1.unlatch(); 
		System.out.println("add 2");
		caq1.add(2);
		caq1.latch();
		System.out.println("add 3");
		caq2.add(3); // throws IllegalStateException
		System.out.println("End"); } }