/** @(#)LatchableArrayQ1.java
 * Array implementation of the latchable queue  first try
 * @version February 22, 2017
 * @author Prof. Solymosi  2010-2017
 * @param E type of the elements in the queue */

package com.solymosi.javaworld.queue.step7;

import com.solymosi.javaworld.queue.step1.ArrayQ;

public class LatchableArrayQ1<E> extends ArrayQ<E> implements ILatchableQ1<E> {
	private boolean latched = false;
	@Override public void latch() {
		latched = true; }
	@Override public void unlatch() {
		latched = false; }
	@Override public boolean isLatched() {
		return latched; }	
	public LatchableArrayQ1(int size) {
		super(size); }
	@Override public void add(E o) {
		if (isLatched())
			throw new IllegalStateException();
		else
			super.add(o); }

	public static void main(String[] args) {
		ILatchableQ1<Integer> laq1 = new LatchableArrayQ1<Integer>(10),
			laq2 = new LatchableArrayQ1<Integer>(10);
		System.out.println("add 1");
		laq1.add(1);
		laq1.latch();
		laq1.unlatch(); 
		System.out.println("add 2");
		laq1.add(2);
		laq1.latch();
		System.out.println("add 3");
		laq2.add(3); } }