/** @(#)ILatchableQ2.java
 * Java 8 interface of the latchable queue  second try
 * A latchable queue can be latched and unlatched; if latched, add() is supposed to throw exception 
 * @version February 22, 2017
 * @author Prof. Solymosi  2010-2017
 * @param E type of the elements in the queue. */

package com.solymosi.javaworld.queue.step7;

import com.solymosi.javaworld.queue.step1.IQ;
public interface ILatchableQ2<E> extends IQ<E> {
	class Latch {
		private boolean latched = false; }
	Latch latch = new Latch();
	default void latch() {
		latch.latched = true; }
	default void unlatch() {
		latch.latched = false; }
	default boolean isLatched() {
		return latch.latched; } }