/** @(#)ILatchableQ.java
 * Interface of the latchable queue  final version
 * A latchable queue can be latched and unlatched; if latched, add() is supposed to throw exception 
 * @version February 22, 2017
 * @author Prof. Solymosi  2010-2017
 * @param E type of the elements in the queue. */

package com.solymosi.javaworld.queue.step7;

import com.solymosi.javaworld.queue.step1.IQ;
public interface ILatchableQ<E> extends IQ<E> {
	class Latch {
		private boolean latched = false; }
	default void latch(Latch latch) {
		latch.latched = true; }
	default void unlatch(Latch latch) {
		latch.latched = false; }
	default boolean isLatched(Latch latch) {
		return latch.latched; } }