/** @(#)Diamond.java
 * Demonstration of diamond inheritance
 * @version February 22, 2017
 * @author Prof. Solymosi  2010-2017 */

package com.solymosi.javaworld.queue.step7;

interface North {
	String status = "north";
	default void method() {
		System.out.println("North " + status); } }
interface West extends North {
	@Override default void method() {
		System.out.println("West " + status); } }
interface East extends North {
	String status = "east";
	@Override default void method() {
		System.out.println("East " + status); } }
class South implements West, East {
	// the compiler requests method() being overridden because of unambiguity of inheritance:
	@Override public void method() {
		West.super.method(); // must be specified which one
		East.super.method();
		System.out.println("South " + West.status); } }
public class Diamond {
	public static void main(String[] args) {
		new South().method(); } } // output: "West north" "East east"
