/** @(#)UnivListQ.java
 * Implementation of the universal list queue in Java 8
 * @version December 6, 2010
 * @version February 22, 2017
 * @author Prof. Solymosi  2010-2017
 * @param E type of the elements in the queue. */

package com.solymosi.javaworld.queue.step6;

import java.util.Iterator;

import com.solymosi.javaworld.queue.step1.ListQ;

class UnivListQ<E> extends ListQ<E> implements IExtItQ<E>, IPersXItQ<E> {
	public Iterator<E> iterator() {
		return new Iterator<E>() { // the same like ItListQueue in Step 4
			private Node node = oldest;
			public boolean hasNext() {
				return node != null; }
			public E next() {
				E nextOne = node.value;
				node = node.next;
				return nextOne; }
			public void remove() {} }; } } // no need for remove()