/** @(#)UnivArrayQ.java
 * Implementation of the universal array queue in Java 8
 * @version December 6, 2010
 * @version February 22, 2017
 * @author Prof. Solymosi  2010-2017
 * @param E type of the elements in the queue. */

package com.solymosi.javaworld.queue.step6;

import java.util.Iterator;

import com.solymosi.javaworld.queue.step1.ArrayQ;

class UnivArrayQ<E> extends ArrayQ<E> implements IExtItQ<E>, IPersXItQ<E> {
	public UnivArrayQ(int size) { super(size); }
	public Iterator<E> iterator() {
		return new Iterator<E>() {
			private int i = 0;
			public boolean hasNext() {
				return i < count; }
			public E next() {
				E nextOne = content[(oldest + i) % content.length];
				i++;
				return nextOne; }
			public void remove() {} }; } } // no need for remove()