/** @(#)IExtItQ.java
 * Interface of the extended queue with default implementation through iterator
 * @version February 22, 2017
 * @author Prof. Solymosi  2010-2017
 * @param E type of the elements in the queue. */

package com.solymosi.javaworld.queue.step6;

import java.util.Iterator;

import com.solymosi.javaworld.queue.step2.IExtQ;

interface IExtItQ<E> extends IExtQ<E>, Iterable<E> {
	default boolean equals(IExtQ<E> q) { // only from Java 8 on
		Iterator<E> thisIt = this.iterator(), // iterator() is abstract method 
			thatIt = ((IExtItQ<E>)q).iterator();
		while (thisIt.hasNext() && thatIt.hasNext())
			if (thisIt.next() != thatIt.next())
				return false;
		return !thisIt.hasNext() && !thatIt.hasNext(); }
	default void copy(IExtQ<E> q) {
			this.clear();
			Iterator<E>	thatIt = ((IExtItQ<E>)q).iterator();
			while (thatIt.hasNext())
				this.add(thatIt.next()); } }