/** @(#)AExtItQChanged.java
 * Changed abstract class of the extended queue for functional abstraction
 * @version February 22, 2017
 * @author Prof. Solymosi  2010-2017
 * @param E type of the elements in the queue. */

package com.solymosi.javaworld.queue.step5;

import java.util.Iterator;
import com.solymosi.javaworld.queue.step2.IExtQ;
import com.solymosi.javaworld.queue.step4.AExtItQ;
import com.solymosi.javaworld.queue.step4.APersXItQ;

/** abstract method is iterator() */
public abstract class AExtItQChanged<E> extends APersXItQ<E> // changed!
		// or vice versa: APersItQChanged extends AExtItQ
		implements IExtQ<E>, Iterable<E> {
	public boolean equals(IExtQ<E> q) {
		Iterator<E> thisIt = this.iterator(), thatIt = ((AExtItQ<E>)q).iterator();
		while (thisIt.hasNext() && thatIt.hasNext())
			if (thisIt.next() != thatIt.next())
				return false;
		return !thisIt.hasNext() && !thatIt.hasNext(); }
	public void copy(IExtQ<E> q) {
		this.clear();
		Iterator<E> thatIt = ((AExtItQ<E>)q).iterator();
		while (thatIt.hasNext())
			this.add(thatIt.next()); } }