/** @(#)ItListQueue.java
 * List queue with iterator
 * @version December 2, 2010
 * @version February 22, 2017
 * @author Prof. Solymosi  2010-2017
 * @param E type of the elements in the queue */

package com.solymosi.javaworld.queue.step4;

import java.util.Iterator;

import com.solymosi.javaworld.queue.step1.ListQ;

public class ItListQ<E> extends ListQ<E> implements Iterable<E> {
	public Iterator<E> iterator() {
		return new Iterator<E>() {
			private Node node = oldest;
			public boolean hasNext() {
				return node != null; }
			public E next() {
				E nextOne = node.value;
				node = node.next;
				return nextOne; }
			public void remove() {} }; } } // no need for remove()