/**@(#)ItArrayQ.java
 * Array queue with iterator
 * @version December 2, 2010
 * @version February 22, 2017
 * @author Prof. Solymosi  2010-2017
 * @param E type of the elements in the queue.
 */

package com.solymosi.javaworld.queue.step4;

import java.util.Iterator;
import com.solymosi.javaworld.queue.step1.ArrayQ;

public class ItArrayQ<E> extends ArrayQ<E> implements Iterable<E> {
	public ItArrayQ(int size) { super(size); }
	public Iterator<E> iterator() {
		return new Iterator<E>() {
			private int i = 0;
			public boolean hasNext() {
				return i < count; }
			public E next() {
				E nextOne = content[(oldest + i) % content.length];
				i++;
				return nextOne; }
			public void remove() {} }; } } // no need for remove()