/** @(#)ExtItListQ.java
 * Extended list queue with iterator
 * @version December 2, 2010
 * @version February 22, 2017
 * @author Prof. Solymosi  2010-2017
 * @param E type of the elements in the queue */

package com.solymosi.javaworld.queue.step4;

import com.solymosi.javaworld.queue.step2.IExtQ;

import java.util.Iterator;

public class ExtItListQ<E> extends ItListQ<E> implements IExtQ<E> {
	public boolean equals(IExtQ<E> that) {
		try {
			@SuppressWarnings("unchecked")
			Iterator<E> thisIt = this.iterator(), 
			thatQ = ((Iterable<E>)that).iterator();
			while (thisIt.hasNext() && thatQ.hasNext())
				if (thisIt.next() != thatQ.next())
					return false;
			return !thisIt.hasNext() && !thatQ.hasNext(); }
		catch (ClassCastException e) { 
			return false; } }
	public void copy(IExtQ<E> q) {
		this.clear();
		ExtItListQ<E> that = (ExtItListQ<E>)q;
		for (Iterator<E> thatIt = that.iterator(); thatIt.hasNext();)
			this.add(thatIt.next()); } }