/** @(#)ExtItArrayQ.java
 * Extended array queue with iterator
 * @version December 2, 2010
 * @version February 22, 2017
 * @author Prof. Solymosi  2010-2017
 * @param E type of the elements in the queue.
 */

package com.solymosi.javaworld.queue.step4;

import com.solymosi.javaworld.queue.step2.IExtQ;

import java.util.Iterator;


public class ExtItArrayQ<E> extends ItArrayQ<E> implements IExtQ<E> {
	public ExtItArrayQ(int size) { super(size); }
	public boolean equals(IExtQ<E> that) {
		try {
			@SuppressWarnings("unchecked")			
			Iterator<E> thisIt = this.iterator(), 
				thatIt = ((Iterable<E>)that).iterator();
			while (thisIt.hasNext() && thatIt.hasNext())
				if (thisIt.next() != thatIt.next())
					return false;
			return !thisIt.hasNext() && !thatIt.hasNext(); }
		catch (ClassCastException e) { 
			return false; } }
	public void copy(IExtQ<E> q) {
		this.clear();
		ExtItArrayQ<E> that = (ExtItArrayQ<E>)q;
		for (Iterator<E> thatIt = that.iterator(); thatIt.hasNext();)
			this.add(thatIt.next()); }}