/** @(#)ExtAbstractedListQ.java
 * Implementation of the extended list queue with functional abstraction
 * @version December 2, 2010
 * @version February 22, 2017
 * @author Prof. Solymosi  2010-2017
 * @param E type of the elements in the queue */

package com.solymosi.javaworld.queue.step4;

import java.util.Iterator;

public class ExtAbstractedListQ<E> extends AExtItQ<E> { // implements Iterable, IExtQ (extends IQ) 
	private ItListQ<E> ilq; // instantiated for simulated inheritance
	public ExtAbstractedListQ() {
		ilq = new ItListQ<E>(); }
	public void add(E o) { ilq.add(o); } // passing through
	public void remove() { ilq.remove(); }
	public E element() { return ilq.element(); }
	public void clear() { ilq.clear(); }
	public boolean isEmpty() { return ilq.isEmpty(); }
	public boolean isFull() { return ilq.isFull(); }
	public Iterator<E> iterator() {
		return ilq.iterator(); } }