/** @(#)ExtAbstractedArrayQ.java
 * Implementation of the extended array queue with functional abstraction
 * @version December 6, 2010
 * @version February 22, 2017
 * @author Prof. Solymosi  2010-2017
 * @param E type of the elements in the queue */

package com.solymosi.javaworld.queue.step4;

import java.util.Iterator;

public class ExtAbstractedArrayQ<E> extends AExtItQ<E> { // implements Iterable, IExtQ (extends IQ) 
private ItArrayQ<E> iaq; // instantiated for simulated inheritance	
	public ExtAbstractedArrayQ(int size) {
		iaq = new ItArrayQ<E>(size); }
	public void add(E o) { iaq.add(o); } // passing through
	public void remove() { iaq.remove(); }
	public E element() { return iaq.element(); }
	public void clear() { iaq.clear(); }
	public boolean isEmpty() { return iaq.isEmpty(); }
	public boolean isFull() { return iaq.isFull(); }
	public Iterator<E> iterator() { return iaq.iterator(); } }