/** @(#)APersXItQ.java
 * Abstract implementation of the persistent queue with XML for functional abstraction
 * @version December 2, 2010
 * @version February 22, 2017
 * @author Prof. Solymosi  2010-2017
 * @param E type of the elements in the queue - must have String parameterized constructor */

package com.solymosi.javaworld.queue.step4;

import com.solymosi.javaworld.queue.step3.IPersQ;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Iterator;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class APersXItQ<E> implements IPersQ<E>, Iterable<E> {
	public void save(String filename) {
		try {
			Document dom = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
			Element root = dom.createElement("queue");
			dom.appendChild(root);
			for (Iterator<E> thisIt = this.iterator(); thisIt.hasNext();) {
				E e = thisIt.next();
				Element element = dom.createElement("element");
				// In order not to lose type information of the element we write the attribute "type":
				element.setAttribute("type", e.getClass().getName());
				element.appendChild(dom.createTextNode(e.toString()));
				root.appendChild(element); }
			TransformerFactory.newInstance().newTransformer().transform(
				new DOMSource(dom), 
				new StreamResult(new FileOutputStream(filename))); }
		 catch (Exception e) { //  
			throw new IllegalStateException(e); } }
	@SuppressWarnings("unchecked")
	public void load(String filename) {
		 try {
			this.clear();
			Document dom = DocumentBuilderFactory.newInstance().
				newDocumentBuilder().parse(new File(filename));		
			Element root = (Element)dom.getElementsByTagName("queue").item(0);
			NodeList elements = root.getElementsByTagName("element");
			for (int i = 0; i < elements.getLength(); i++) {
				Element element = (Element)elements.item(i);
				// unfortunately NodeList is not (yet) Iterable, therefore 
				// for (Element element : elemente) is not possible
				String value = element.getChildNodes().item(0).getNodeValue();
				String type = element.getAttribute("type"); // Wert des Attributs

				// evaluate type information over reflexion:
				// first create a Class-object of type of the elements,
				// then call its constructor with String parameter 
				// and then insert the element of type E
				Object instance = Class.forName(type).getConstructor(Class.forName("java.lang.String")).newInstance(value);
				this.add((E)instance); } }
		 catch (Exception e) {
			throw new IllegalStateException(e); } }	 }

class PersArrayQ1<E> extends APersXItQ<E> {
	private ItArrayQ<E> iaq; 
	public PersArrayQ1(int size) {
		iaq = new ItArrayQ<E>(size); }
	public void add(E o) { iaq.add(o); }
	public void remove() { iaq.remove(); }
	public E element() { return iaq.element(); }
	public void clear() { iaq.clear(); }
	public boolean isEmpty() { return iaq.isEmpty(); }
	public boolean isFull() { return iaq.isFull(); }
	public Iterator<E> iterator() { return iaq.iterator(); } }
class PersListQ1<E> extends APersXItQ<E> {
	private ItListQ<E> ilq; 
	public PersListQ1() {
		ilq = new ItListQ<E>(); }
	public void add(E o) { ilq.add(o); }
	public void remove() { ilq.remove(); }
	public E element() { return ilq.element(); }
	public void clear() { ilq.clear(); }
	public boolean isEmpty() { return ilq.isEmpty(); }
	public boolean isFull() { return ilq.isFull(); }
	public Iterator<E> iterator() { return ilq.iterator(); } }