/** @(#)PersXArrayQ.java
 * Array implementation of the persistent queue with XML
 * @version December 2, 2010
 * @version February 22, 2017
 * @author Prof. Solymosi  2010-2017
 * @param E type of the elements in the queue */

package com.solymosi.javaworld.queue.step3;

import com.solymosi.javaworld.queue.step1.ArrayQ;

import java.io.File;
import java.io.FileOutputStream;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PersXArrayQ<E> extends ArrayQ<E> implements IPersQ<E> {
	public PersXArrayQ(int size) {
		super(size);
	}
	@Override public void save(String filename) {
	    try {	    	
	    	Document dom = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
	    	Element root = dom.createElement("queue");
	    	dom.appendChild(root);

	    	for (int i = oldest; i < count; i = (i+1) % content.length) {
	    		E value = content[i];
	    		Element element = dom.createElement("element");

				// In order not to lose type information of the element we write the attribute "type":
	    		String clazz = "" + value.getClass(); // z.B. "class java.lang.String"
	    		clazz = clazz.substring(6); // cut off "class " 
	    		element.setAttribute("type", clazz); // type of the elements
	    		element.appendChild(dom.createTextNode("" + value));
	    		root.appendChild(element); }

	    		TransformerFactory.newInstance().newTransformer(). transform(new DOMSource(dom),
	    			new StreamResult(new FileOutputStream(filename))); }
	    catch (Exception e) {
	    	throw new IllegalStateException(e); } }
	@SuppressWarnings("unchecked")
	@Override public void load(String filename) {
		 try {
			  Document dom = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new File(filename));
			  Element root = (Element)dom.getElementsByTagName("queue").item(0);
			  int size = Integer.parseInt(root.getAttribute("length"));
			  content = (E[])new Object[size]; // workaround for generic object creation

			  NodeList elements = root.getElementsByTagName("element");
			  for (int i = 0; i < elements.getLength(); i++) {
			    Element element = (Element)elements.item(i);
				String value = element.getChildNodes().item(0).getNodeValue();
			    String type = element.getAttribute("type"); // value of the attribut "type"

			    // evaluate type information over reflexion:
				// first create a Class-object of type of the elements,
				// then call its constructor with String parameter 
				// and then insert the element of type E
				Object instance = Class.forName(type).getConstructor(Class.forName("java.lang.String")).newInstance(value);
				this.add((E)instance); } }
			 catch (Exception e) {
				 throw new IllegalStateException(e); } } }