/** @(#)PersOListQ.java
 * List implementation of the persistent queue with ObjectStream
 * @version February 22, 2017
 * @author Prof. Solymosi  2010-2017
 * @param E type of the elements in the queue */

package com.solymosi.javaworld.queue.step3;

import com.solymosi.javaworld.queue.step1.ListQ;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

@SuppressWarnings("serial")
public class PersOListQ<E> extends ListQ<E> implements IPersQ<E>, Serializable {
	@Override public void save(String filename) {
		try {
			ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(filename));
			oos.writeObject(this);
			oos.close();
		} catch (Exception e) {
			throw new IllegalStateException(e); } }
	@SuppressWarnings("unchecked")
	@Override public void load(String filename) {
		try {
			ObjectInputStream ois = new ObjectInputStream(new FileInputStream(filename));
			PersOListQ<E> result = (PersOListQ<E>)ois.readObject();
			ois.close();
			this.oldest = result.oldest; }
	    catch (Exception e) {
	        throw new IllegalStateException(e); } } }