/** @(#)PersOArrayQ.java
 * Array implementation of the persistent queue with ObjectStream
 * @version February 22, 2017
 * @author Prof. Solymosi  2010-2017
 * @param E type of the elements in the queue */

package com.solymosi.javaworld.queue.step3;

import com.solymosi.javaworld.queue.step1.ArrayQ;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

@SuppressWarnings("serial")
public class PersOArrayQ<E> extends ArrayQ<E> implements IPersQ<E>, Serializable {
	public PersOArrayQ(int size) {
		super(size);
	}
	@Override public void save(String filename) {
		ObjectOutputStream oos;
		try {
			oos = new ObjectOutputStream(new FileOutputStream(filename));
			oos.writeObject(this);
			oos.close();
		} catch (Exception e) {
			throw new IllegalStateException(e); } }
	@SuppressWarnings("unchecked")
	@Override public void load(String filename) {
		try {
			ObjectInputStream ois = new ObjectInputStream(new FileInputStream(filename));
			PersOArrayQ<E> result = (PersOArrayQ<E>)ois.readObject();
			ois.close();
			this.content = result.content; }
	    catch (Exception e) {
	        throw new IllegalStateException(e); } } }