/** @(#)PersQ.java
 * Interface of the persistent queue
 * @version December 2, 2010
 * @version February 22, 2017
 * @author Prof. Solymosi  2010-2017
 * @param E type of the elements in the queue. */

package com.solymosi.javaworld.queue.step3;

import com.solymosi.javaworld.queue.step1.IQ;

public interface IPersQ<E> extends IQ<E> {
	/** Stores the content of the queue into a file. The queue remains unchanged.
	* @throws IllegalStateException if saving not possible. */
	void save(final String filename); // const
	/** Loads the content of the queue from a file. The old content gets lost.
	* !@ensures equals() loaded queue not necessarily equals the saved one
	* @throws IllegalStateException if loading not possible */
	void load(final String filename); }