/** @(#)ExtQ.java
 * Extended queue interface with equals and copy
 * @version December 2, 2010
 * @version February 22, 2017
 * @author Prof. Solymosi  2010-2017
 * @param E type of the elements in the queue. */
package com.solymosi.javaworld.queue.step2;

import com.solymosi.javaworld.queue.step1.IQ;

public interface IExtQ<E> extends IQ<E> {
	/** Compares the elements with another queue. Both queues remain unchanged.
	* @param q the other queue.
	* @result true if both queues contain the same objects in the same order.
	* @result false also if the types of both queues are different: q.getClass() != this.getClass() */
	boolean equals(final IExtQ<E> q); // const
	/** Copies the elements of the parameter queue. Parameter queue remains unchanged. 
	* @throws OutOfMemoryError
	* @ensures equals(copy()) 	*/
	void copy(final IExtQ<E> q); }