/** @(#)ExtListQ.java
 * List implementation of the extended queue
 * @version December 2, 2010
 * @version February 22, 2017
 * @author Prof. Solymosi  2010-2017
 * @param E type of the elements in the queue */

package com.solymosi.javaworld.queue.step2;

import com.solymosi.javaworld.queue.step1.ListQ;

public class ExtListQ<E> extends ListQ<E> implements IExtQ<E> {
	public boolean equals(final IExtQ<E> q) { // const
		try {
			ExtListQ<E> that = (ExtListQ<E>)q;
			Node thisQ = this.oldest, thatQ = that.oldest;
			while (thisQ != null && thatQ != null) {
				if (thisQ.value != thatQ.value) // different contents
					return false;
				thisQ = thisQ.next;
				thatQ = thatQ.next; 	}
			return thisQ == null && thatQ == null; } // different sizes?
		catch (ClassCastException e) { // if (q.getClass() != this.getClass())
			return false; } }
	public void copy(final IExtQ<E> q) {
		this.clear();
		ExtListQ<E> that = (ExtListQ<E>)q;
		Node node = that.oldest;
		while (node != null) {
			this.add(node.value);
			node = node.next; } } }