/** @(#)ExtArrayQ.java
 * Array implementation of the extended queue
 * @version December 2, 2010
 * @version February 22, 2017
 * @author Prof. Solymosi  2010-2017
 * @param E type of the elements in the queue */

package com.solymosi.javaworld.queue.step2;

import com.solymosi.javaworld.queue.step1.ArrayQ;

public class ExtArrayQ<E> extends ArrayQ<E> implements IExtQ<E> {
	public ExtArrayQ(int size) {
		super(size); }
	public boolean equals(final IExtQ<E> q) { // const
		if (q.getClass() != this.getClass()) // different types
			return false;
		ExtArrayQ<E> that = (ExtArrayQ<E>)q; // cast for attribute access
		if (this.count != that.count) // different sizes
			return false;
		int thisQ = this.oldest; // index in this
		int thatQ = that.oldest; // index in that
		for (int i = 0; i < that.count; i++) {
			if (this.content[thisQ] != that.content[thatQ]) // different contents
				return false;
			thisQ = (thisQ + 1) % this.content.length; // cyclic access
			thatQ = (thatQ + 1) % that.content.length; }
		return true; }
	public void copy(final IExtQ<E> q) {
		super.clear(); // delete old content
		ExtArrayQ<E> that = (ExtArrayQ<E>)q;
		for (int i = 0; i < that.count; i++)
			this.add(that.content[(that.oldest + i) % that.content.length]); } }