/** @(#)VectorQ.java
 * Vector implementation of the queue interface
 * @version February 22, 2017
 * @author Prof. Solymosi  2010-2017
 * @param E type of the elements in the queue */
package com.solymosi.javaworld.queue.step1;

import java.util.NoSuchElementException;
import java.util.Vector;
public class VectorQ<E> implements IQ<E> {
	protected Vector<E> content;
	public void clear() {
		content.clear(); }
	public VectorQ() {
		content = new Vector<E>();
		clear(); }
	public boolean isEmpty() {
		return content.isEmpty(); }
	public boolean isFull() {
		return false; } // never full (hopefully)
	public void add(final E o) {
		content.add(o); }
	public E element() {
		if (isEmpty())
			throw new NoSuchElementException();
		else
			return content.get(0); } // oldest element
	public void remove() {
		if (isEmpty())
			throw new NoSuchElementException();
		else {
			content.remove(0); } // oldest element 
	} }