/** @(#)ListQ.java
 * List implementation of the queue interface
 * @version December 2, 2010
 * @version February 22, 2017
 * @param E type of the elements in the queue */
package com.solymosi.javaworld.queue.step1;

import java.util.NoSuchElementException;

public class ListQ<E> implements IQ<E> {
	public class Node { // inner class
		public E value;
		public Node next;
		Node (E value, Node next) {
			this.value = value;
			this.next = next; }
		Node(final E value) {
			this(value, null); } }
	protected Node oldest, youngest;
	public ListQ() {
		clear(); }
	public void clear() {
		oldest = null; }
	public boolean isEmpty() {
		return oldest == null; }
	public void add(final E o) {
		if (isFull())
			throw new IllegalStateException();
		Node newNode = new Node(o);
		if (isEmpty())
			oldest = newNode;
		else
			youngest.next = newNode;
		youngest = newNode; }
	public E element() {
		if (isEmpty())
			throw new NoSuchElementException();
		else
			return oldest.value; }
	public void remove() {
		if (isEmpty())
			throw new NoSuchElementException();
		else
			oldest = oldest.next; }
	public boolean isFull() { // full only if no Node can be created
		try {
			new Node(null); // trial
			return false; } // success
		catch (OutOfMemoryError e) { // no success
			return true; } } }