/** @(#)IQ.java
 * A (reduced) interface for queue: A FIFO collection
 * @version December 2, 2010
 * @version February 22, 2017
 * @author Prof. Solymosi  2010-2017
 * @param E type of the elements in the queue. */

package com.solymosi.javaworld.queue.step1;

public interface IQ<E> {
	/** Inserts the specified element into the queue, if possible.
	* @param o the element to insert.
	* @throws IllegalStateException if the queue is full. 	*/
	void add(final E o);
	/** Removes the head of the queue.
	* @throws NoSuchElementException if the queue is empty. */
	void remove();
	/** Retrieves, but does not remove, the head of the queue. 
	* @return the head of the queue.
	* @throws NoSuchElementException if the queue is empty. */
	E element();
	/** Makes the queue empty */
	public void clear();
	/** Tells whether the queue is empty.
	* @return true if remove and element would throw NoSuchElementException. */
	boolean isEmpty();
	/** Tells whether the queue is full. 
	* @return true if add would throw IllegalStateException. */
	boolean isFull(); }