/** @(#)ArrayQ.java
 * Array implementation of the queue interface
 * @version December 2, 2010
 * @version February 22, 2017
 * @author Prof. Solymosi  2010-2017
 * @param E type of the elements in the queue */

package com.solymosi.javaworld.queue.step1;

import java.util.NoSuchElementException;
public class ArrayQ<E> implements IQ<E> {
	protected E[] content;
	protected int youngest, oldest, count;
	public void clear() {
		count = 0;
		oldest = 0;
		youngest = content.length-1; } // recently (latest) occupied index
	@SuppressWarnings("unchecked")
	public ArrayQ(final int size) {
		content = (E[])new Object[size]; // workaround for generic object creation
		clear(); }
	public boolean isEmpty() {
		return count == 0; }
	public boolean isFull() {
		return count == content.length; }
	public void add(final E o) {
		if (isFull())
			throw new IllegalStateException();
		count++;
		youngest = (youngest + 1) % content.length; // cyclic access 
		content[youngest] = o; }
	public E element() {
		if (isEmpty())
			throw new NoSuchElementException();
		else
			return content[oldest]; }
	public void remove() {
		if (isEmpty())
			throw new NoSuchElementException();
		else {
			oldest = (oldest + 1) % content.length; // beim berlauf wird 0	
			count--; } } }

